@rem OssImport Console for Windows 

@echo off
set curdir=%~dp0
cd /d %curdir%
setlocal enabledelayedexpansion

set CMD_JAR=bin/ossimport2.jar
set SYS_CONF=conf/sys.properties
set JOB_CONF=conf/local_job.cfg
set JOB_NAME=local_test

rem 提交任务
if /i "%1" == "submit" (
    java -jar %CMD_JAR% -c %SYS_CONF% submit %JOB_CONF% 2>&1
    goto COMPETE
)

rem 启动迁移/校验服务
if /i "%1" == "start" (
    start java -jar -Xmx1024m %CMD_JAR% -c %SYS_CONF% start 2>&1
    goto COMPETE
)

rem 清除提交过的任务
if /i "%1" == "clean" (
    java -jar %CMD_JAR% -c %SYS_CONF% clean %JOB_NAME%
    goto COMPETE
)

rem 查看任务状态
if /i "%1" == "stat" (
    java -jar %CMD_JAR% -c %SYS_CONF% stat detail
    goto COMPETE
)

rem 重试失败的子任务
if /i "%1" == "retry" (
    java -jar %CMD_JAR% -c %SYS_CONF% retry %JOB_NAME%
    goto COMPETE
)

rem 无效命令
echo Support command:
echo    submit: submit job
echo    start: start import service
echo    clean: clean old job
echo    stat: stat job
echo    retry: retry all failed tasks
goto QUIT

rem 完成任务后退出
:COMPETE
echo %1 competed

rem 出错退出
:QUIT
