#!/bin/bash
# OssImport Console for Linux

#######################################################
# Define function
#######################################################

function usage()
{
    echo "Support command:"
    echo "    submit: submit job"
    echo "    start: start import service"
    echo "    stop: stop import service"
    echo "    clean: clean old job"
    echo "    stat: stat job"
    echo "    retry: retry all failed tasks"
}

function start_import_service()
{
    nohup java -Dskip_exist_file=false -jar ${work_dir}/bin/ossimport2.jar -c ${work_dir}/conf/sys.properties start > ${work_dir}/logs/ossimport2.log 2>&1 &
    sleep 1s
    echo "Start import service completed."
}

function stop_import_service()
{
    ps axu | grep "ossimport2.jar.* start" | grep -v grep | awk '{print "kill -9 "$2}' | bash > /dev/null
    sleep 1s
    echo "Stop import service completed."
}

function submit_job()
{
    java -jar $work_dir/bin/ossimport2.jar -c $work_dir/conf/sys.properties submit $work_dir/conf/local_job.cfg > ${work_dir}/logs/submit.log 2>&1
    submit_result=$(grep "Error:" ${work_dir}/logs/submit.log)
    if [ -z "$submit_result" ]; then
        # successful
        cat ${work_dir}/logs/submit.log
    else
        # failed
        cat ${work_dir}/logs/submit.log
    fi
}

function clean_job()
{
    java -jar $work_dir/bin/ossimport2.jar -c $work_dir/conf/sys.properties clean ${job_name}
    echo "Clean job:${job_name} completed."
}

function stat_job()
{
    java -jar $work_dir/bin/ossimport2.jar -c $work_dir/conf/sys.properties stat detail
}

function retry_failed_tasks()
{
    java -jar $work_dir/bin/ossimport2.jar -c $work_dir/conf/sys.properties retry ${job_name} > ${work_dir}/logs/retry.log 2>&1
    retry_result=$(cat ${work_dir}/logs/retry.log)
    if [ -z "$retry_result" ]; then
        echo "None failed tasks for job:${job_name}."
    else
        cat ${work_dir}/logs/retry_result.log
        echo "Retry has been submitted."
    fi
    
}

#######################################################
# Start of main
#######################################################

work_dir=
command=
job_name="local_test"

# check args
if [ "$#" -ne 1 ]; then
   usage
   exit
fi
command=$1
echo "Command:${command}"

# get work dir
osname=$(uname)
if [ "$osname" = "Linux" ]; then
    work_dir=$( dirname $(readlink -f $0) )
else
    work_dir=$( cd "$( dirname "$0" )" && pwd )
fi

echo "WorkDir:${work_dir}"

# execute command
case ${command} in
    start | Start)
        start_import_service
        ;;
    stop | Stop)
        stop_import_service
        ;;
    submit | Submit)
        submit_job
        ;;
    clean | Clean)
        clean_job
        ;;
    stat | Stat)
        stat_job
        ;;
    retry | Retry)
        retry_failed_tasks
        ;;
    *)
        usage
        exit
        ;;
esac
